# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, datetime2stamp, stamp2datetime, interface_response, online_employee, \
    save_notification, remove_history, MESSAGE_CODE, SUCCESS_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, user_photo, paging
import json
from django.utils.translation import ugettext_lazy as _


class BioTimeAppSchedule(object):

    """
    【Schedule】排班
    """

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def pull_schedule(self, start_date, end_date, source, device_token, language, token):
        """
        获取排班信息
        @param start_date:          开始日期
        @param end_date:            结束日期
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype: 返回执行结果
        """
        from mysite.att.attendance_calculate.views import att_calculate
        from mysite.sql_utils import p_query
        import datetime
        now = datetime.datetime.now()
        start = stamp2datetime(start_date)
        end = stamp2datetime(end_date)
        print "[*]Schedule Range: {0} --> {1}".format(start, end)
        emp = online_employee()
        att_calculate([emp.pk, ], datetime.datetime(start.year, start.month, start.day), end)
        sql = """
            select a.AttDate, s.SchName, a.ClockInTime, a.ClockOutTime, a.cacl_check_in, cacl_check_out, a.Late, a.Early, a.Absent, a.leave_time, a.OverTime
            from attshifts a
            left join schclass s on a.SchId = s.SchclassID
            where userid = %s and a.AttDate >= '%s' and a.AttDate <= '%s'
        """ % (emp.pk, start.strftime('%Y-%m-%d'), end.strftime('%Y-%m-%d'))
        rows = p_query(sql)
        vals = {}
        if rows:
            for r in rows:
                att_date = r[0]
                key = att_date.strftime('%Y%m%d')
                vals[key] = {
                    'date': '{0}'.format(att_date.strftime('%Y-%m-%d')),
                    'shift': '{0}'.format(r[1]),
                    'set_in': '{0}'.format(r[2]),
                    'set_out': '{0}'.format(r[3]),
                    'check_in': '{0}'.format(r[4]),
                    'check_out': '{0}'.format(r[5]),
                    'late': '{0}'.format(int(r[6]) and 1 or 0),
                    'early_leave': '{0}'.format(int(r[7]) and 1 or 0),
                    'absent': '{0}'.format(int(r[8]) and 1 or 0),
                    'leave': '{0}'.format(int(r[9]) and 1 or 0),
                    'overtime': '{0}'.format(int(r[10]) and 1 or 0)
                }
        items = []
        loop_date = start
        while loop_date <= end:
            day = loop_date.strftime('%Y%m%d')
            item = vals.get(day, {
                'date': '{0}'.format(loop_date.strftime('%Y-%m-%d')),
                'shift': '',
                'set_in': '',
                'set_out': '',
                'check_in': '',
                'check_out': '',
                'late': '0',
                'early_leave': '0',
                'absent': '0',
                'leave': '0',
                'overtime': '0'
            })
            if loop_date > now:
                item['late'] = '0'
                item['early_leave'] = '0'
                item['absent'] = '0'
                item['leave'] = '0'
                item['overtime'] = '0'
            items.append(item)
            loop_date += datetime.timedelta(days=1)
        return interface_response(SUCCESS_CODE, json.dumps(items), '', 'successful')

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def pull_shift(self, source, device_token, language, token):
        """
        获取班次信息
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype: 返回执行结果
        {"code": 1, "error": "", "describe":"", "message":"", "data": [{"code": 1, "name": "DubaiOffice(08:00-18:00)"}, ]}
        """
        from mysite.att.models.schclass import SchClass
        try:
            objs = SchClass.objects.all().order_by('timetable_type').values('SchclassID', 'SchName', 'StartTime', 'EndTime')
            vals = [{
                'code': obj['SchclassID'],
                'name': u'{0}({1}-{2})'.format(obj['SchName'], obj['StartTime'].strftime('%H:%M'), obj['EndTime'].strftime('%H:%M'))
            } for obj in objs]
            return interface_response(SUCCESS_CODE, json.dumps(vals),  '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(SUCCESS_CODE, '',  '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(long, str, int, str, int, str, str, str, rtype=str)
    def apply(self, att_date, previous_shift, adjust_shift, remark, source, device_token, language, token):
        """
        调班申请
        @param att_date:            调班日期
        @param previous_shift:      当前班次名称
        @param adjust_shift:        调整班次
        @param remark:              备注
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype: 返回执行结果
        """
        from mysite.att.models.model_schedule import ChangeSchedule
        from mysite.att import constant
        from mysite.att.models.schclass import SchClass
        from mysite.att.att_utils import approve_flow

        if att_date:
            att_date = stamp2datetime(att_date)
            applier = online_employee()
            try:
                currently = SchClass.objects.filter(SchclassID=adjust_shift)
                if not currently:
                    describe = 'Adjust shift not found'
                    return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
                obj = ChangeSchedule()
                obj.emp = applier
                obj.att_date = att_date
                obj.previous_shift = previous_shift
                obj.timetable_id = adjust_shift
                obj.remark = u'{0}'.format(remark.decode('utf-8'))
                obj.approve_level = 1
                obj.save()
                obj, approve_level = approve_flow(constant.CATEGORY_SCHEDULE, obj, applier, applier.PIN, '', None, None)
                obj.save()
                data = {
                    'message': u'{0}'.format(_(u'Request already processing'))
                }
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Object Not Found'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def my_application(self, approve_status, page_num, source, device_token, language, token):
        """
        获取自己的调班申请(申请,通过,拒绝)数据
        @param approve_status:      0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:            页码（每页１５条数据）
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.iclock.models.model_notification import CATEGORY_SCHEDULE

        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (2, 3) '
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' u.userid = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='schedule_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = {
                    'category': CATEGORY_SCHEDULE,
                    'items': []
                }
                if rows:
                    status = dict(constant.ALL_STATUS)
                    items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                              'previous_shift': r[3] or 'None', 'currently_shift': r[4],
                              'remark': r[5], 'category': r[6].strftime('%Y-%m-%d'), 'apply_time': datetime2stamp(r[7]),
                              'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                              'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                    data['items'] = items
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'parameter approve_status={0} error'.format(approve_status)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, int, str, str, str, rtype=str)
    def approval_list(self, approve_status, page_num, order_by, source, device_token, language, token):
        """
        获取审批列表
        @param approve_status:      0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:            页码（每页１５条数据）
        @param order_by:            排序(1: 申请时间，２：审批时间), 申请界面默认为１，审批界面默认为２
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
            {"code":1,"error":"","describe":"","message":"","data":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","previous_shift":"原班次","currently_shift":"调整班次","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (%s, %s, %s) ' % (constant.AUDIT_SUCCESS, constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            elif approve_status in (constant.REFUSE, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' pdr.approver_id = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            print "[*]Where:", where
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='schedule_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = []
                if rows:
                    status = dict(constant.ALL_STATUS)
                    data = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                             'previous_shift': r[3] or 'None', 'currently_shift': r[4],
                             'remark': r[5], 'category': r[6].strftime('%Y-%m-%d'), 'apply_time': datetime2stamp(r[7]),
                             'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                             'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])
                             } for r in rows]
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Approve status not in (0,1,2,3)'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, int, str, str, str, rtype=str)
    def approve(self, code, approve_status, remark, source, device_token, language, token):
        """
        调班申请审批
        @param code:                对象ID
        @param approve_status:      审核状态(通过/拒绝)
        @param remark:              备注
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"message":"弹窗消息"}}
            请求失败
                {"code": -10001, "error": "", "describe": "错误描述", "message": "弹窗信息", "data":""}
        """
        from mysite.att.models.model_schedule import ChangeSchedule
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history

        if approve_status not in (constant.AUDIT_SUCCESS, constant.REFUSE):
            describe = 'param approve_status out of range'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        objs = ChangeSchedule.objects.filter(id=code)
        if objs:
            try:
                approver = online_employee()
                obj = objs[0]
                applier = obj.emp
                level = obj.approve_level
                obj.audit_reason = remark
                obj.audit_user_id = approver.pk
                approver_name = approver.EName or approver.PIN
                obj, approve_level = approve_flow(constant.CATEGORY_SCHEDULE, obj, applier, applier.PIN, '', approver_name, approve_status)
                obj.save()
                approver = approver.PIN
                save_history(constant.CATEGORY_SCHEDULE, obj.pk, level, approve_status, approver, approver_name, remark)
                data = {
                    'message': u'{0}'.format(_(u'OK'))
                }
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Object Not Found'
            return interface_response(SUCCESS_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, str, str, rtype=str)
    def revoke(self, code, source, device_token, language, token):
        """
        调班申请撤销
        @param code:                对象ID
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from mysite.att.models.model_schedule import ChangeSchedule
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        from mysite.att.models.user_temp_sch import USER_TEMP_SCH
        import datetime
        if code:
            approver = online_employee()
            objs = ChangeSchedule.objects.filter(id=code)
            if objs:
                obj = objs[0]
                if obj.audit_status not in (constant.AUDIT_SUCCESS, ):
                    message = _(u'Not allowed')
                    return interface_response(MESSAGE_CODE, '', '', '', message)
                applier = obj.emp
                obj.audit_status = constant.CANCEL_AUDIT_SUCCESS
                obj.audit_user_id = approver.pk
                obj.audit_reason = ''
                super(ChangeSchedule, obj).save()
                timetable = obj.timetable
                if timetable == 1:
                    change_time = timetable.change_at
                    start = '{0} {1}'.format(obj.att_date.strftime('%Y-%m-%d'), change_time.strftime('%H:%M:%S'))
                    start = datetime.datetime.strptime(start,  '%Y-%m-%d %H:%M:%S')
                    end = start - datetime.timedelta(microseconds=1)
                else:
                    start = '{0} {1}'.format(obj.att_date.strftime('%Y-%m-%d'), timetable.StartTime.strftime('%H:%M:%S'))
                    start = datetime.datetime.strptime(start,  '%Y-%m-%d %H:%M:%S')
                    end = '{0} {1}'.format(obj.att_date.strftime('%Y-%m-%d'), timetable.EndTime.strftime('%H:%M:%S'))
                    end = datetime.datetime.strptime(end,  '%Y-%m-%d %H:%M:%S')
                uts = USER_TEMP_SCH.objects.filter(UserID=obj.emp, SchclassID=timetable.pk, ComeTime=start, LeaveTime=end)
                if uts:
                    uts.delete()
                approve_level = obj.approve_level + 1
                approver_name = approver.EName or approver.PIN
                approver = approver.PIN
                save_history(constant.CATEGORY_SCHEDULE, obj.pk, approve_level, constant.CANCEL_AUDIT_SUCCESS, approver, approver_name, '')
                obj, approve_level = approve_flow(constant.CATEGORY_SCHEDULE, obj, applier, applier.PIN, '', approver_name, constant.CANCEL_AUDIT_SUCCESS)
                obj.save()
                data = {
                    'message': u'{0}'.format(_(u'OK'))
                }
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            else:
                describe = 'Object Not Fund'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        else:
            describe = 'Parameter instance missing'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)